  
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_CONCILIACAO_EQUALS]') AND type IN (N'P', N'PC'))
    DROP PROCEDURE [dbo].P_GERA_CONCILIACAO_EQUALS
GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20220607
'Job.................:  
'Nome................: P_GERA_CONCILIACAO_EQUALS
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: --
'Criado por..........: --
'Alterado por........: 
'=======================================================================================
FARMAGOI-23856
*/
CREATE   PROCEDURE P_GERA_CONCILIACAO_EQUALS(@ID_REMESSA AS VARCHAR(100)) AS
SET NOCOUNT ON;
DECLARE @IDT_LOTE INT
DECLARE @LOTE VARCHAR(100)
DECLARE @TIPO_MOVIMENTO VARCHAR(100)
DECLARE @AUTORIZACAO VARCHAR(100)
DECLARE @CD_FILIAL INT
DECLARE @VALOR_BRUTO MONEY
DECLARE @VALOR_LIQUIDO MONEY
DECLARE @VALOR_COMISSAO MONEY
DECLARE @DATA_MOVIMENTO DATE
DECLARE @DATA_VENDA DATE
DECLARE @DATA_VENCIMENTO_PARCELA DATE
DECLARE @NUMERO_PARCELA INT
DECLARE @TOTAL_PARCELAS INT
DECLARE @ST_STATUS_LOTE INT
DECLARE @CD_BANCO INT
DECLARE @AGENCIA VARCHAR(20)
DECLARE @CONTA VARCHAR(20)
DECLARE @NUMERO_UNICO_ERP VARCHAR(100)
DECLARE @MOTIVO VARCHAR(100)
DECLARE @IDT_TRANSACAO INT 
DECLARE @CD_BANDEIRA INT 
DECLARE @DS_BANDEIRA VARCHAR(100)
DECLARE @CD_GRP_ECON INT 

DECLARE Movimentos CURSOR FAST_FORWARD READ_ONLY FOR 
SELECT
  ei.LOTE,
  ei.TIPO_MOVIMENTO,
  ei.AUTORIZACAO,
  CAST(ei.CODIGO_ESTABELECIMENTO_CLIENTE AS INT) AS CD_FILIAL,
  CAST(ei.VALOR_BRUTO as MONEY) as VALOR_BRUTO,
  CAST(ei.VALOR_LIQUIDO as MONEY) as VALOR_LIQUIDO,
  CAST(ei.VALOR_COMISSAO as MONEY) as VALOR_COMISSAO,
  CAST(ei.DATA_MOVIMENTO as DATE) as DATA_MOVIMENTO,
  CAST(ei.DATA_VENDA as DATE) as DATA_VENDA,
  CASE WHEN ei.DATA_VENCIMENTO_PARCELA = '' THEN NULL ELSE CAST(ei.DATA_VENCIMENTO_PARCELA as DATE) END as DATA_VENCIMENTO_PARCELA,
  ei.NUMERO_PARCELA,
  ei.TOTAL_PARCELAS,
  CASE ei.SITUACAO_CONCILIACAO
    WHEN 1 THEN 0 --Em Aberto > Nao Encontrado
    WHEN 2 THEN 1 --Divergente > Divergente
    WHEN 3 THEN 2 --Conciliada > Conciliado
    WHEN 4 THEN 2 --Conciliada Manualmente > Conciliado
    WHEN 5 THEN 2 --Justificada > Conciliado
    WHEN 6 THEN 0 --Nao Aplicavel > Nao Encontrado
    ELSE 0 --Nao Encontrado
  END as ST_STATUS_LOTE,
  ISNULL(bc.CD_BC, CASE WHEN ei.BANCO = '0' THEN NULL ELSE ei.BANCO END) as CD_BANCO,
  CAST(ISNULL(bc.AGC_CNT, CASE WHEN ei.AGENCIA = '0' THEN NULL ELSE ei.AGENCIA END) as VARCHAR(20)) as AGENCIA,
  CAST(ISNULL(bc.NR_CNT, CASE WHEN ei.CONTA = '0' THEN NULL ELSE ei.CONTA END) as VARCHAR(20)) as CONTA,
  ei.NUMERO_UNICO_ERP,
  ei.MOTIVO,
  ei.BANDEIRA as CD_BANDEIRA,
  ei.NOME_BANDEIRA as DS_BANDEIRA
FROM EQUALSCORE_IMPORTACAO ei
LEFT JOIN EQUALSCORE_CONFIG_CONTA ecc ON(ecc.CD_FILIAL = CAST(EI.CODIGO_ESTABELECIMENTO_CLIENTE AS INT) AND ecc.COD_BANDEIRA = ei.BANDEIRA)
LEFT JOIN BC_CONTAS bc ON(bc.CD_CNT = ecc.CD_CNT)
WHERE EI.ID_REMESSA = @ID_REMESSA
--WHERE EI.ID_REMESSA = '10000000000000000'
AND ei.TIPO_MOVIMENTO IN('D1', 'D2', 'D3', 'H1', 'H2', 'H3')
ORDER BY ei.NUMERO_SEQUENCIAL
OPEN Movimentos;

FETCH NEXT FROM Movimentos 
INTO @LOTE, @TIPO_MOVIMENTO, @AUTORIZACAO, @CD_FILIAL, @VALOR_BRUTO, @VALOR_LIQUIDO, @VALOR_COMISSAO, @DATA_MOVIMENTO, @DATA_VENDA, @DATA_VENCIMENTO_PARCELA, @NUMERO_PARCELA, @TOTAL_PARCELAS, @ST_STATUS_LOTE, @CD_BANCO, @AGENCIA, @CONTA, @NUMERO_UNICO_ERP, @MOTIVO, @CD_BANDEIRA, @DS_BANDEIRA
WHILE @@FETCH_STATUS = 0
BEGIN  
  --PRINT 'LOTE ' + @LOTE
  SET @IDT_LOTE = ISNULL((
    SELECT x.IDT_LOTE
    FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE x
    WHERE x.LOTE = @LOTE AND x.CD_FILIAL = @CD_FILIAL
  ), 0)

  IF (@IDT_LOTE = 0)
  BEGIN
    SET @IDT_LOTE = ISNULL((SELECT MAX(x.IDT_LOTE) FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE x), 0) + 1
	SET @CD_GRP_ECON = (SELECT MAX(x.CD_GRP_ECON) FROM PRC_GRP_ECON_PRC_FILIAL x WHERE x.CD_FILIAL = @CD_FILIAL AND CD_EMP = 1)
	
    INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE(IDT_LOTE, LOTE, CD_EMP, CD_FILIAL, CD_GRUPO, TPT_REGISTRO, NR_PARCELAS, VLR_BRUTO, VLR_LIQUIDO, TAXA_ADMINISTRADORA, DT_LOTE, ST_STATUS, CD_BANCO, AGENCIA, CONTACORRENTE, CD_BANDEIRA, DS_BANDEIRA)
    VALUES(@IDT_LOTE, @LOTE, 1, @CD_FILIAL, @CD_GRP_ECON, 7, @TOTAL_PARCELAS, @VALOR_BRUTO, @VALOR_LIQUIDO, @VALOR_COMISSAO, @DATA_MOVIMENTO, @ST_STATUS_LOTE, @CD_BANCO, @AGENCIA, @CONTA, @CD_BANDEIRA, @DS_BANDEIRA)
  END

  SET @IDT_TRANSACAO = ISNULL(TRY_PARSE(@AUTORIZACAO AS INT), 0)
  IF ((@TIPO_MOVIMENTO IN('D1', 'D2', 'D3')) AND (@IDT_TRANSACAO > 0) 
  AND NOT EXISTS(
    SELECT 1
    FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PARC x
    WHERE x.IDT_TRANSACAO = @IDT_TRANSACAO
    AND x.NR_PARCELA = @NUMERO_PARCELA
	AND x.CD_FILIAL = @CD_FILIAL))
  BEGIN
    INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_PARC(CD_EMP, CD_FILIAL, TPT_REGISTRO, IDT_TRANSACAO, NR_PARCELA, VLR_BRUTO_LOJA, VLR_LIQUIDO_LOJA,
      DT_PREVISAO_PAGAMENTO_LOJA, ST_LOJA, VLR_BRUTO_REDE, VLR_LIQUIDO_REDE, DT_PREVISAO_PAGAMENTO_REDE, ST_REDE, ST_CONCILIACAO)
    VALUES(1, @CD_FILIAL, 4, @IDT_TRANSACAO, @NUMERO_PARCELA, @VALOR_BRUTO, @VALOR_LIQUIDO, 
      ISNULL(@DATA_VENCIMENTO_PARCELA, @DATA_MOVIMENTO), NULL, @VALOR_BRUTO, @VALOR_LIQUIDO, ISNULL(@DATA_VENCIMENTO_PARCELA, @DATA_MOVIMENTO), NULL, @ST_STATUS_LOTE)
  END

  IF (@TIPO_MOVIMENTO IN('D1') AND NOT EXISTS(
    SELECT 1
    FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO x
    WHERE x.IDT_LOTE = @IDT_LOTE
    AND x.PARCELA_LOTE = @NUMERO_PARCELA))
  BEGIN
    INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO(IDT_LOTE, CD_EMP, CD_FILIAL, TPT_REGISTRO, PARCELA_LOTE, VLR_BRUTO, VLR_LIQUIDO, DT_PAGAMENTO, ST_STATUS, LOTE_PAGAMENTO, CD_BANCO, AGENCIA, CONTACORRENTE)
    VALUES(@IDT_LOTE, 1, @CD_FILIAL, 8, @NUMERO_PARCELA, @VALOR_BRUTO, @VALOR_LIQUIDO, @DATA_MOVIMENTO, @ST_STATUS_LOTE, @LOTE, @CD_BANCO, @AGENCIA, @CONTA)
  END

  IF (@TIPO_MOVIMENTO IN('D2', 'D3') AND NOT EXISTS(
    SELECT 1
    FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_ANTECIP x
    WHERE x.IDT_LOTE = @IDT_LOTE
    AND x.PARCELA_LOTE = @NUMERO_PARCELA))
  BEGIN
    INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_ANTECIP(IDT_LOTE, CD_EMP, CD_FILIAL, TPT_REGISTRO, PARCELA_LOTE, VLR_LIQUIDO_PARCELA, VLR_LIQUIDO_ANTECIPADO, DT_ANTECIPACAO, DT_PREVISTA_PAGAMENTO, ST_STATUS, NR_DOCUMENTO, VLR_DESCONTO, LOTE_PAGAMENTO, CD_BANCO, AGENCIA, CONTACORRENTE)
    VALUES(@IDT_LOTE, 1, @CD_FILIAL, 9, @NUMERO_PARCELA, @VALOR_BRUTO, @VALOR_LIQUIDO, @DATA_MOVIMENTO, @DATA_MOVIMENTO, @ST_STATUS_LOTE, @NUMERO_UNICO_ERP, @VALOR_COMISSAO, @LOTE, @CD_BANCO, @AGENCIA, @CONTA)
  END

  IF (@TIPO_MOVIMENTO IN('H1', 'H2', 'H3') AND NOT EXISTS(
    SELECT 1
    FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_AJUSTE x
    WHERE x.IDT_LOTE = @IDT_LOTE
    AND x.PARCELA_LOTE = @NUMERO_PARCELA))
  BEGIN
    INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_AJUSTE(IDT_LOTE, CD_EMP, CD_FILIAL, TPT_REGISTRO, PARCELA_LOTE, IDT_AJUSTE, DT_VENDA, TPT_AJUSTE, VLR_BRUTO, VLR_LIQUIDO, DT_PREVISAO_PAGAMENTO, DT_PAGAMENTO, OBSERVACAO, ST_STATUS, DT_AJUSTE, LOTE_PAGAMENTO, CD_BANCO, AGENCIA, CONTACORRENTE)
    VALUES(@IDT_LOTE, 1, @CD_FILIAL, 5, @NUMERO_PARCELA, 0, @DATA_VENDA, 0, @VALOR_BRUTO, @VALOR_LIQUIDO, @DATA_MOVIMENTO, @DATA_MOVIMENTO, @MOTIVO, @ST_STATUS_LOTE, @DATA_MOVIMENTO, @LOTE, @CD_BANCO, @AGENCIA, @CONTA)
  END
FETCH NEXT FROM Movimentos 
INTO @LOTE, @TIPO_MOVIMENTO, @AUTORIZACAO, @CD_FILIAL, @VALOR_BRUTO, @VALOR_LIQUIDO, @VALOR_COMISSAO, @DATA_MOVIMENTO, @DATA_VENDA, @DATA_VENCIMENTO_PARCELA, @NUMERO_PARCELA, @TOTAL_PARCELAS, @ST_STATUS_LOTE, @CD_BANCO, @AGENCIA, @CONTA, @NUMERO_UNICO_ERP, @MOTIVO, @CD_BANDEIRA, @DS_BANDEIRA
END
CLOSE Movimentos
DEALLOCATE Movimentos
